%% Mother Wavelet
% Martin H. Trauth 1 July 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all
ds = get(0,'ScreenSize');

%%
% We then display a Morlet mother wavelet with wavenumber 6
eta = -10 : 0.1 : 10;
w0 = 6;
wave = pi.^(-1/4) .* exp(i*w0*eta) .* exp(-eta.^2/2);

f1 = figure('Position',[50 ds(4)-500 800 300],...
    'Color','w');
axes('Position',[0.1 0.15 0.8 0.7])
line(eta,wave,...
    'LineWidth',1)
xlabel('Position')
ylabel('Scale')
title('Morlet Mother Wavelet')

print(f1,'-dpng','-r300','figure_7_motherwavelet.png')





